# بسته‌ی پنل آزمون آنلاین (Laravel) — نسخه Template v1.0

این بسته شامل فایل‌های لازم (migrations, models, controllers, views, routes, middleware, seeders) است تا آن را داخل پروژه Laravel شما کپی کنید.

## پیش‌نیازها
- Laravel 12.x
- Starter kit برای لاگین (پیشنهاد: Breeze Blade)
  - نصب: `composer require laravel/breeze --dev`
  - اجرا: `php artisan breeze:install blade`
  - سپس: `npm install && npm run build`

> اگر Breeze نصب ندارید، این بسته باز هم قابل استفاده است، اما برای لاگین ادمین باید سیستم auth را داشته باشید.

## نصب سریع
1) محتویات این بسته را در ریشه پروژه Laravel خود کپی کنید (فولدرهای app/, database/, resources/, routes/).
2) فایل `.env` را برای SQLite تنظیم کنید:
   ```env
   DB_CONNECTION=sqlite
   DB_DATABASE=database/database.sqlite
   ```
   و فایل دیتابیس را بسازید:
   - ویندوز:
     ```bat
     type nul > database\database.sqlite
     ```
   - لینوکس:
     ```bash
     touch database/database.sqlite
     ```
3) مایگریشن و seed:
   ```bash
   php artisan migrate
   php artisan db:seed --class=ExamSystemSeeder
   ```

## فعال‌کردن middleware ادمین (Laravel 11/12)
در `bootstrap/app.php` این alias را اضافه کنید:

```php
->withMiddleware(function (Illuminate\Foundation\Configuration\Middleware $middleware) {
    $middleware->alias([
        'admin' => \App\Http\Middleware\EnsureAdmin::class,
    ]);
})
```

## مسیرها
- پنل ادمین: `/admin`
- دانش‌آموز: `/student`

## اکانت پیشفرض ادمین
- username: `admin@example.com`
- password: `admin123`

بعد از ورود، از منوی «حساب کاربری» رمز را تغییر دهید.

## مهاجرت به MySQL/MariaDB
فقط `.env` را عوض کنید:
```env
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=exam_db
DB_USERNAME=root
DB_PASSWORD=
```
و سپس:
```bash
php artisan migrate --force
```

## اکسل (اختیاری)
برای import/export واقعی Excel (xlsx) پیشنهاد می‌شود:
```bash
composer require maatwebsite/excel
```
این بسته فعلاً Template را به صورت CSV ارائه می‌کند (قابل باز شدن در Excel).
