<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class AccountController extends Controller
{
    public function security()
    {
        return view('admin.account.security');
    }

    public function changePassword(Request $request)
    {
        $data = $request->validate([
            'current_password' => 'required|string',
            'password' => 'required|string|min:8|confirmed',
        ]);

        $user = $request->user();
        if (!Hash::check($data['current_password'], $user->password)) {
            return back()->withErrors(['current_password' => 'رمز فعلی اشتباه است.']);
        }

        $user->password = Hash::make($data['password']);
        $user->save();

        return back()->with('ok', 'رمز عبور تغییر کرد.');
    }

    public function twofa()
    {
        // برای 2FA واقعی: pragmarx/google2fa-laravel پیشنهاد می‌شود.
        return view('admin.account.twofa');
    }
}
