<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Attempt;
use Illuminate\Http\Request;

class ResultController extends Controller
{
    public function index(Request $request)
    {
        $q = trim((string)$request->query('q', ''));
        $status = $request->query('status', '');
        $attempts = Attempt::query()
            ->when($q !== '', function ($qq) use ($q) {
                $qq->where('exam_title_snapshot', 'like', "%{$q}%")
                   ->orWhere('student_name_snapshot', 'like', "%{$q}%")
                   ->orWhere('student_code_snapshot', 'like', "%{$q}%")
                   ->orWhere('code_snapshot', 'like', "%{$q}%");
            })
            ->when($status !== '', fn($qq) => $qq->where('status', $status))
            ->orderByDesc('id')
            ->paginate(20)
            ->withQueryString();

        return view('admin.results.index', compact('attempts', 'q', 'status'));
    }

    public function show(Attempt $attempt)
    {
        $attempt->load('answers');
        return view('admin.results.show', compact('attempt'));
    }

    public function destroy(Attempt $attempt)
    {
        $attempt->delete();
        return redirect()->route('admin.results.index')->with('ok', 'نتیجه حذف شد (حذف نرم).');
    }
}
