<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\AntiCheatSetting;
use Illuminate\Http\Request;

class SettingsController extends Controller
{
    public function anticheat()
    {
        $s = AntiCheatSetting::query()->firstOrFail();
        return view('admin.settings.anticheat', ['s' => $s]);
    }

    public function saveAnticheat(Request $request)
    {
        $s = AntiCheatSetting::query()->firstOrFail();

        $data = $request->validate([
            'full_screen_required' => 'nullable|boolean',
            'prevent_tab_switch' => 'nullable|boolean',
            'max_tab_switch_allowed' => 'required|integer|min:0|max:999',
            'block_copy_paste' => 'nullable|boolean',
            'disable_right_click' => 'nullable|boolean',
            'prevent_reload' => 'nullable|boolean',
            'shuffle_questions' => 'nullable|boolean',
            'shuffle_choices' => 'nullable|boolean',
            'lock_to_device' => 'nullable|boolean',
        ]);

        foreach ([
            'full_screen_required','prevent_tab_switch','block_copy_paste','disable_right_click',
            'prevent_reload','shuffle_questions','shuffle_choices','lock_to_device'
        ] as $boolField) {
            $data[$boolField] = (bool)$request->boolean($boolField, false);
        }

        $s->update($data);

        return back()->with('ok', 'تنظیمات ذخیره شد.');
    }
}
