<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Answer extends Model
{
    protected $fillable = [
        'attempt_id',
        'question_id',
        'question_text_snapshot',
        'choices_snapshot',
        'correct_index_snapshot',
        'selected_index',
        'is_correct',
        'score_awarded',
    ];

    protected $casts = [
        'choices_snapshot' => 'array',
        'is_correct' => 'boolean',
    ];

    public function attempt()
    {
        return $this->belongsTo(Attempt::class);
    }

    public function question()
    {
        return $this->belongsTo(Question::class);
    }
}
