<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Attempt extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'exam_id',
        'student_id',
        'invite_code_id',
        'started_at',
        'finished_at',
        'score',
        'score_percent',
        'status',
        'ip',
        'user_agent',
        'tab_switch_count',
        'exam_title_snapshot',
        'student_name_snapshot',
        'student_code_snapshot',
        'code_snapshot',
    ];

    protected $casts = [
        'started_at' => 'datetime',
        'finished_at' => 'datetime',
        'score_percent' => 'float',
    ];

    public function exam()
    {
        return $this->belongsTo(Exam::class);
    }

    public function student()
    {
        return $this->belongsTo(Student::class);
    }

    public function inviteCode()
    {
        return $this->belongsTo(InviteCode::class);
    }

    public function answers()
    {
        return $this->hasMany(Answer::class);
    }
}
