<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Exam extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'title',
        'description',
        'duration_minutes',
        'pass_threshold',
        'start_at',
        'end_at',
        'show_answers_after_minutes',
        'is_active',
    ];

    protected $casts = [
        'start_at' => 'datetime',
        'end_at' => 'datetime',
        'is_active' => 'boolean',
    ];

    public function questions()
    {
        return $this->hasMany(Question::class);
    }

    public function inviteCodes()
    {
        return $this->hasMany(InviteCode::class);
    }

    public function attempts()
    {
        return $this->hasMany(Attempt::class);
    }
}
