<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Question extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'exam_id',
        'question_text',
        'choices',
        'correct_index',
        'score',
        'image_path',
        'is_active',
    ];

    protected $casts = [
        'choices' => 'array',
        'is_active' => 'boolean',
    ];

    public function exam()
    {
        return $this->belongsTo(Exam::class);
    }
}
