<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Student extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'student_code',
        'full_name',
        'class_name',
        'phone',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    public function inviteCodes()
    {
        return $this->hasMany(InviteCode::class);
    }

    public function attempts()
    {
        return $this->hasMany(Attempt::class);
    }
}
