<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('anti_cheat_settings', function (Blueprint $table) {
            $table->id();
            $table->boolean('full_screen_required')->default(false);
            $table->boolean('prevent_tab_switch')->default(true);
            $table->unsignedInteger('max_tab_switch_allowed')->default(3);
            $table->boolean('block_copy_paste')->default(false);
            $table->boolean('disable_right_click')->default(false);
            $table->boolean('prevent_reload')->default(false);
            $table->boolean('shuffle_questions')->default(true);
            $table->boolean('shuffle_choices')->default(true);
            $table->boolean('lock_to_device')->default(false);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('anti_cheat_settings');
    }
};
