<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('questions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('exam_id')->constrained('exams');
            $table->text('question_text');
            $table->json('choices'); // ["A","B","C","D"]
            $table->unsignedTinyInteger('correct_index'); // 0..3
            $table->unsignedInteger('score')->default(1);
            $table->string('image_path')->nullable();
            $table->boolean('is_active')->default(true)->index();
            $table->timestamps();
            $table->softDeletes();
            $table->index('question_text');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('questions');
    }
};
