<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('invite_codes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('exam_id')->constrained('exams');
            $table->foreignId('student_id')->nullable()->constrained('students')->nullOnDelete();

            $table->string('code')->unique();
            $table->timestamp('expires_at');
            $table->timestamp('used_at')->nullable()->index();

            $table->string('used_ip')->nullable();
            $table->text('used_user_agent')->nullable();

            // snapshots (history)
            $table->string('student_snapshot_name')->nullable();
            $table->string('student_snapshot_code')->nullable();

            $table->timestamps();
            $table->softDeletes();
            $table->index(['exam_id','code']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('invite_codes');
    }
};
