<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('attempts', function (Blueprint $table) {
            $table->id();

            // nullable to keep history even if exam/student deleted
            $table->foreignId('exam_id')->nullable()->constrained('exams')->nullOnDelete();
            $table->foreignId('student_id')->nullable()->constrained('students')->nullOnDelete();

            $table->foreignId('invite_code_id')->constrained('invite_codes');

            $table->timestamp('started_at');
            $table->timestamp('finished_at')->nullable();
            $table->unsignedInteger('score')->default(0);
            $table->float('score_percent')->default(0);

            $table->enum('status', ['OK','FLAGGED','TERMINATED'])->default('OK');

            // telemetry
            $table->string('ip')->nullable();
            $table->text('user_agent')->nullable();
            $table->unsignedInteger('tab_switch_count')->default(0);

            // snapshots
            $table->string('exam_title_snapshot');
            $table->string('student_name_snapshot')->nullable();
            $table->string('student_code_snapshot')->nullable();
            $table->string('code_snapshot');

            $table->timestamps();
            $table->softDeletes();
            $table->index(['exam_title_snapshot','student_name_snapshot','student_code_snapshot','code_snapshot']);
        });

        Schema::create('answers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('attempt_id')->constrained('attempts')->cascadeOnDelete();

            $table->foreignId('question_id')->nullable()->constrained('questions')->nullOnDelete();

            // snapshots
            $table->text('question_text_snapshot');
            $table->json('choices_snapshot');
            $table->unsignedTinyInteger('correct_index_snapshot');

            $table->unsignedTinyInteger('selected_index');
            $table->boolean('is_correct');
            $table->unsignedInteger('score_awarded')->default(0);

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('answers');
        Schema::dropIfExists('attempts');
    }
};
