<?php

namespace Database\Seeders;

use App\Models\AntiCheatSetting;
use App\Models\AppMeta;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class ExamSystemSeeder extends Seeder
{
    public function run(): void
    {
        // Template version
        AppMeta::query()->firstOrCreate(['id' => 1], ['template_version' => '1.0']);

        // Default anti-cheat settings
        AntiCheatSetting::query()->firstOrCreate(['id' => 1], [
            'full_screen_required' => false,
            'prevent_tab_switch' => true,
            'max_tab_switch_allowed' => 3,
            'block_copy_paste' => false,
            'disable_right_click' => false,
            'prevent_reload' => false,
            'shuffle_questions' => true,
            'shuffle_choices' => true,
            'lock_to_device' => false,
        ]);

        // Admin user
        $adminEmail = 'admin@example.com';
        if (!User::query()->where('email', $adminEmail)->exists()) {
            User::query()->create([
                'name' => 'Admin',
                'email' => $adminEmail,
                'password' => Hash::make('admin123'),
                'is_admin' => true,
                'email_verified_at' => now(),
            ]);
        }
    }
}
