<x-admin-layout>
    <div class="flex items-center justify-between flex-wrap gap-3">
        <h1 class="text-xl font-bold">کدهای آزمون: {{ $exam->title }}</h1>
        <a class="rounded-2xl border px-4 py-2" href="{{ route('admin.exams.index') }}">بازگشت</a>
    </div>

    <div class="mt-4 grid gap-3 rounded-2xl border bg-white p-4">
        <h2 class="font-bold">تولید کد جدید</h2>
        <form method="post" action="{{ route('admin.codes.generate', $exam) }}" class="grid gap-3">
            @csrf
            <div class="grid md:grid-cols-3 gap-3">
                <div>
                    <label class="block text-sm mb-1">تعداد</label>
                    <input type="number" name="count" value="10" min="1" max="500" class="w-full rounded-2xl border px-4 py-2" />
                </div>
                <div>
                    <label class="block text-sm mb-1">اعتبار (ساعت)</label>
                    <input type="number" name="expires_hours" value="24" min="1" max="720" class="w-full rounded-2xl border px-4 py-2" />
                </div>
                <div class="flex items-end">
                    <button class="rounded-2xl bg-indigo-600 text-white px-4 py-2 w-full">تولید</button>
                </div>
            </div>

            <div class="text-sm text-slate-600">
                (اختیاری) اتصال کدها به دانش‌آموزان:
            </div>
            <select multiple name="student_ids[]" class="w-full rounded-2xl border px-4 py-2 h-40">
                @foreach($students as $s)
                    <option value="{{ $s->id }}">{{ $s->full_name }} ({{ $s->student_code }})</option>
                @endforeach
            </select>
            <div class="text-xs text-slate-500">اگر دانش‌آموز انتخاب کنید، کدها به صورت چرخشی بین آن‌ها تقسیم می‌شود.</div>
        </form>
    </div>

    <div class="mt-4">@include('admin._searchbar')</div>

    <div class="mt-4 overflow-auto rounded-2xl border bg-white">
        <table class="min-w-[1000px] w-full text-sm">
            <thead class="bg-slate-50 text-slate-600">
            <tr>
                <th class="p-3 text-right">کد</th>
                <th class="p-3 text-right">دانش‌آموز</th>
                <th class="p-3 text-right">انقضا</th>
                <th class="p-3 text-right">وضعیت</th>
                <th class="p-3 text-right">عملیات</th>
            </tr>
            </thead>
            <tbody>
            @foreach($codes as $c)
                @php($expired = now()->greaterThan($c->expires_at))
                <tr class="border-t">
                    <td class="p-3 font-mono text-lg">{{ $c->code }}</td>
                    <td class="p-3">{{ $c->student_snapshot_name ? $c->student_snapshot_name . ' (' . $c->student_snapshot_code . ')' : '—' }}</td>
                    <td class="p-3">{{ $c->expires_at->format('Y-m-d H:i') }}</td>
                    <td class="p-3">
                        @if($c->used_at)
                            <span class="inline-flex rounded-full px-2 py-1 text-xs bg-slate-100 text-slate-700">استفاده شده</span>
                        @elseif($expired)
                            <span class="inline-flex rounded-full px-2 py-1 text-xs bg-rose-50 text-rose-700">منقضی</span>
                        @else
                            <span class="inline-flex rounded-full px-2 py-1 text-xs bg-emerald-50 text-emerald-700">آماده</span>
                        @endif
                    </td>
                    <td class="p-3">
                        <form method="post" action="{{ route('admin.codes.destroy', $c) }}" onsubmit="return confirm('حذف شود؟');">
                            @csrf @method('DELETE')
                            <button class="rounded-xl bg-rose-600 text-white px-3 py-1">حذف</button>
                        </form>
                    </td>
                </tr>
            @endforeach
            @if($codes->count()===0)
                <tr><td class="p-6 text-center text-slate-500" colspan="5">موردی یافت نشد.</td></tr>
            @endif
            </tbody>
        </table>
    </div>

    <div class="mt-4">{{ $codes->links() }}</div>
</x-admin-layout>
