@php($e = $exam)
<div>
    <label class="block text-sm mb-1">عنوان</label>
    <input name="title" value="{{ old('title', $e?->title) }}" class="w-full rounded-2xl border px-4 py-2" required />
</div>

<div>
    <label class="block text-sm mb-1">توضیحات</label>
    <textarea name="description" class="w-full rounded-2xl border px-4 py-2" rows="3">{{ old('description', $e?->description) }}</textarea>
</div>

<div class="grid grid-cols-1 md:grid-cols-2 gap-3">
    <div>
        <label class="block text-sm mb-1">مدت آزمون (دقیقه)</label>
        <input type="number" name="duration_minutes" value="{{ old('duration_minutes', $e?->duration_minutes ?? 30) }}" class="w-full rounded-2xl border px-4 py-2" required />
    </div>
    <div>
        <label class="block text-sm mb-1">حد نصاب قبولی (%)</label>
        <input type="number" name="pass_threshold" value="{{ old('pass_threshold', $e?->pass_threshold ?? 60) }}" class="w-full rounded-2xl border px-4 py-2" required />
    </div>
</div>

<div class="grid grid-cols-1 md:grid-cols-2 gap-3">
    <div>
        <label class="block text-sm mb-1">شروع (اختیاری)</label>
        <input type="datetime-local" name="start_at" value="{{ old('start_at', $e?->start_at?->format('Y-m-d\TH:i')) }}" class="w-full rounded-2xl border px-4 py-2" />
    </div>
    <div>
        <label class="block text-sm mb-1">پایان (اختیاری)</label>
        <input type="datetime-local" name="end_at" value="{{ old('end_at', $e?->end_at?->format('Y-m-d\TH:i')) }}" class="w-full rounded-2xl border px-4 py-2" />
    </div>
</div>

<div>
    <label class="block text-sm mb-1">نمایش پاسخنامه بعد از (دقیقه، اختیاری)</label>
    <input type="number" name="show_answers_after_minutes" value="{{ old('show_answers_after_minutes', $e?->show_answers_after_minutes) }}" class="w-full rounded-2xl border px-4 py-2" />
</div>

<label class="inline-flex items-center gap-2">
    <input type="checkbox" name="is_active" value="1" {{ old('is_active', $e?->is_active ?? true) ? 'checked' : '' }} />
    <span>فعال</span>
</label>
