<x-admin-layout>
    <div class="flex items-center justify-between gap-3 flex-wrap">
        <h1 class="text-xl font-bold">آزمون‌ها</h1>
        <a href="{{ route('admin.exams.create') }}" class="rounded-2xl bg-indigo-600 text-white px-4 py-2">آزمون جدید</a>
    </div>

    <div class="mt-4">@include('admin._searchbar')</div>

    <div class="mt-4 overflow-auto rounded-2xl border bg-white">
        <table class="min-w-[900px] w-full text-sm">
            <thead class="bg-slate-50 text-slate-600">
                <tr>
                    <th class="p-3 text-right">عنوان</th>
                    <th class="p-3 text-right">مدت</th>
                    <th class="p-3 text-right">فعال</th>
                    <th class="p-3 text-right">عملیات</th>
                </tr>
            </thead>
            <tbody>
                @foreach($exams as $exam)
                    <tr class="border-t">
                        <td class="p-3 font-medium">{{ $exam->title }}</td>
                        <td class="p-3">{{ $exam->duration_minutes }} دقیقه</td>
                        <td class="p-3">
                            <span class="inline-flex rounded-full px-2 py-1 text-xs {{ $exam->is_active ? 'bg-emerald-50 text-emerald-700' : 'bg-slate-100 text-slate-600' }}">
                                {{ $exam->is_active ? 'فعال' : 'غیرفعال' }}
                            </span>
                        </td>
                        <td class="p-3 flex gap-2 flex-wrap">
                            <a class="rounded-xl border px-3 py-1" href="{{ route('admin.exams.edit', $exam) }}">ویرایش</a>
                            <a class="rounded-xl border px-3 py-1" href="{{ route('admin.questions.index', $exam) }}">سوالات</a>
                            <a class="rounded-xl border px-3 py-1" href="{{ route('admin.codes.index', $exam) }}">کدها</a>
                            <form method="post" action="{{ route('admin.exams.destroy', $exam) }}" onsubmit="return confirm('حذف شود؟');">
                                @csrf @method('DELETE')
                                <button class="rounded-xl bg-rose-600 text-white px-3 py-1">حذف</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
                @if($exams->count()===0)
                    <tr><td class="p-6 text-center text-slate-500" colspan="4">موردی یافت نشد.</td></tr>
                @endif
            </tbody>
        </table>
    </div>

    <div class="mt-4">{{ $exams->links() }}</div>
</x-admin-layout>
