<!doctype html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ $title ?? 'پنل آزمون آنلاین' }}</title>
    @vite(['resources/css/app.css','resources/js/app.js'])
    <style>
        body { font-family: ui-sans-serif, system-ui, -apple-system, "Vazirmatn", "IRANSans", "Segoe UI", sans-serif; }
    </style>
</head>
<body class="bg-slate-50 text-slate-900">
    <header class="sticky top-0 z-20 bg-white/80 backdrop-blur border-b">
        <div class="max-w-6xl mx-auto px-4 py-3 flex items-center justify-between">
            <div class="flex items-center gap-3">
                <div class="font-extrabold text-lg">پنل آزمون آنلاین</div>
                <div class="text-xs text-slate-500">Template v1.0</div>
            </div>
            <div class="flex items-center gap-2 text-sm">
                <a class="px-3 py-2 rounded-xl hover:bg-slate-100" href="{{ route('admin.exams.index') }}">آزمون‌ها</a>
                <a class="px-3 py-2 rounded-xl hover:bg-slate-100" href="{{ route('admin.students.index') }}">دانش‌آموزان</a>
                <a class="px-3 py-2 rounded-xl hover:bg-slate-100" href="{{ route('admin.results.index') }}">نتایج</a>
                <a class="px-3 py-2 rounded-xl hover:bg-slate-100" href="{{ route('admin.settings.anticheat') }}">ضدتقلب</a>
                <a class="px-3 py-2 rounded-xl hover:bg-slate-100" href="{{ route('admin.account.security') }}">حساب کاربری</a>
            </div>
        </div>
    </header>

    <main class="max-w-6xl mx-auto px-4 py-6">
        @if (session('ok'))
            <div class="mb-4 rounded-2xl border border-emerald-200 bg-emerald-50 px-4 py-3 text-emerald-800">{{ session('ok') }}</div>
        @endif
        @if ($errors->any())
            <div class="mb-4 rounded-2xl border border-rose-200 bg-rose-50 px-4 py-3 text-rose-800">
                <ul class="list-disc pr-6">
                    @foreach ($errors->all() as $e)
                        <li>{{ $e }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        {{ $slot }}
    </main>
</body>
</html>
