<x-admin-layout>
    <div class="flex items-center justify-between flex-wrap gap-3">
        <h1 class="text-xl font-bold">سوالات آزمون: {{ $exam->title }}</h1>
        <a class="rounded-2xl border px-4 py-2" href="{{ route('admin.exams.edit', $exam) }}">بازگشت به آزمون</a>
    </div>

    <div class="mt-4">@include('admin._searchbar')</div>

    <div class="mt-6 rounded-2xl border bg-white p-4">
        <h2 class="font-bold mb-3">افزودن سوال</h2>
        <form class="grid gap-3" method="post" action="{{ route('admin.questions.store', $exam) }}">
            @csrf
            <textarea name="question_text" class="w-full rounded-2xl border px-4 py-2" rows="2" placeholder="متن سوال..." required>{{ old('question_text') }}</textarea>
            <div class="grid md:grid-cols-2 gap-3">
                <input name="choice0" class="rounded-2xl border px-4 py-2" placeholder="گزینه A" required />
                <input name="choice1" class="rounded-2xl border px-4 py-2" placeholder="گزینه B" required />
                <input name="choice2" class="rounded-2xl border px-4 py-2" placeholder="گزینه C" required />
                <input name="choice3" class="rounded-2xl border px-4 py-2" placeholder="گزینه D" required />
            </div>
            <div class="grid md:grid-cols-3 gap-3">
                <select name="correct_index" class="rounded-2xl border px-4 py-2">
                    <option value="0">پاسخ صحیح: A</option>
                    <option value="1">پاسخ صحیح: B</option>
                    <option value="2">پاسخ صحیح: C</option>
                    <option value="3">پاسخ صحیح: D</option>
                </select>
                <input type="number" name="score" class="rounded-2xl border px-4 py-2" value="1" min="1" max="100" />
                <label class="inline-flex items-center gap-2 px-2">
                    <input type="checkbox" name="is_active" value="1" checked />
                    <span>فعال</span>
                </label>
            </div>
            <button class="rounded-2xl bg-indigo-600 text-white px-4 py-2 w-fit">ثبت سوال</button>
        </form>
    </div>

    <div class="mt-4 overflow-auto rounded-2xl border bg-white">
        <table class="min-w-[1100px] w-full text-sm">
            <thead class="bg-slate-50 text-slate-600">
            <tr>
                <th class="p-3 text-right">متن</th>
                <th class="p-3 text-right">امتیاز</th>
                <th class="p-3 text-right">وضعیت</th>
                <th class="p-3 text-right">تصویر</th>
                <th class="p-3 text-right">عملیات</th>
            </tr>
            </thead>
            <tbody>
            @foreach($questions as $qu)
                <tr class="border-t align-top">
                    <td class="p-3">
                        <div class="font-medium">{{ $qu->question_text }}</div>
                        <div class="text-xs text-slate-500 mt-1">
                            A) {{ $qu->choices[0] }} | B) {{ $qu->choices[1] }} | C) {{ $qu->choices[2] }} | D) {{ $qu->choices[3] }}
                        </div>
                    </td>
                    <td class="p-3">{{ $qu->score }}</td>
                    <td class="p-3">
                        <span class="inline-flex rounded-full px-2 py-1 text-xs {{ $qu->is_active ? 'bg-emerald-50 text-emerald-700' : 'bg-slate-100 text-slate-600' }}">
                            {{ $qu->is_active ? 'فعال' : 'غیرفعال' }}
                        </span>
                    </td>
                    <td class="p-3">
                        @if($qu->image_path)
                            <img class="h-12 w-16 object-cover rounded-xl border" src="{{ asset('storage/'.$qu->image_path) }}" />
                        @else
                            <span class="text-xs text-slate-400">—</span>
                        @endif
                    </td>
                    <td class="p-3">
                        <details class="rounded-xl border p-2">
                            <summary class="cursor-pointer">ویرایش</summary>
                            <form class="mt-2 grid gap-2" method="post" action="{{ route('admin.questions.update', $qu) }}">
                                @csrf @method('PUT')
                                <textarea name="question_text" class="w-full rounded-xl border px-3 py-2" rows="2" required>{{ $qu->question_text }}</textarea>
                                <div class="grid md:grid-cols-2 gap-2">
                                    <input name="choice0" class="rounded-xl border px-3 py-2" value="{{ $qu->choices[0] }}" required />
                                    <input name="choice1" class="rounded-xl border px-3 py-2" value="{{ $qu->choices[1] }}" required />
                                    <input name="choice2" class="rounded-xl border px-3 py-2" value="{{ $qu->choices[2] }}" required />
                                    <input name="choice3" class="rounded-xl border px-3 py-2" value="{{ $qu->choices[3] }}" required />
                                </div>
                                <div class="grid md:grid-cols-3 gap-2">
                                    <select name="correct_index" class="rounded-xl border px-3 py-2">
                                        @for($i=0;$i<4;$i++)
                                            <option value="{{ $i }}" {{ $qu->correct_index===$i ? 'selected':'' }}>پاسخ صحیح: {{ ['A','B','C','D'][$i] }}</option>
                                        @endfor
                                    </select>
                                    <input type="number" name="score" class="rounded-xl border px-3 py-2" value="{{ $qu->score }}" min="1" max="100" />
                                    <button class="rounded-xl bg-slate-900 text-white px-3 py-2">ذخیره</button>
                                </div>
                            </form>

                            <form class="mt-2 flex items-center gap-2 flex-wrap" method="post" action="{{ route('admin.questions.image', $qu) }}" enctype="multipart/form-data">
                                @csrf
                                <input type="file" name="image" accept="image/*" class="text-xs" />
                                <button class="rounded-xl border px-3 py-2">آپلود تصویر</button>
                            </form>

                            <div class="mt-2 flex gap-2 flex-wrap">
                                <form method="post" action="{{ route('admin.questions.toggle', $qu) }}">
                                    @csrf
                                    <button class="rounded-xl border px-3 py-2">{{ $qu->is_active ? 'غیرفعال کن' : 'فعال کن' }}</button>
                                </form>
                                <form method="post" action="{{ route('admin.questions.destroy', $qu) }}" onsubmit="return confirm('حذف شود؟');">
                                    @csrf @method('DELETE')
                                    <button class="rounded-xl bg-rose-600 text-white px-3 py-2">حذف</button>
                                </form>
                            </div>
                        </details>
                    </td>
                </tr>
            @endforeach
            @if($questions->count()===0)
                <tr><td class="p-6 text-center text-slate-500" colspan="5">موردی یافت نشد.</td></tr>
            @endif
            </tbody>
        </table>
    </div>

    <div class="mt-4">{{ $questions->links() }}</div>
</x-admin-layout>
