<x-admin-layout>
    <div class="flex items-center justify-between gap-3 flex-wrap">
        <h1 class="text-xl font-bold">نتایج</h1>
        <form method="get" class="flex items-center gap-2 flex-wrap">
            <input name="q" value="{{ $q ?? '' }}" class="w-72 max-w-full rounded-2xl border px-4 py-2" placeholder="جستجو..." />
            <select name="status" class="rounded-2xl border px-4 py-2">
                <option value="">همه وضعیت‌ها</option>
                <option value="OK" {{ $status==='OK'?'selected':'' }}>OK</option>
                <option value="FLAGGED" {{ $status==='FLAGGED'?'selected':'' }}>FLAGGED</option>
                <option value="TERMINATED" {{ $status==='TERMINATED'?'selected':'' }}>TERMINATED</option>
            </select>
            <button class="rounded-2xl bg-slate-900 text-white px-4 py-2">جستجو</button>
        </form>
    </div>

    <div class="mt-4 overflow-auto rounded-2xl border bg-white">
        <table class="min-w-[1100px] w-full text-sm">
            <thead class="bg-slate-50 text-slate-600">
                <tr>
                    <th class="p-3 text-right">آزمون</th>
                    <th class="p-3 text-right">دانش‌آموز</th>
                    <th class="p-3 text-right">کد</th>
                    <th class="p-3 text-right">درصد</th>
                    <th class="p-3 text-right">وضعیت</th>
                    <th class="p-3 text-right">عملیات</th>
                </tr>
            </thead>
            <tbody>
                @foreach($attempts as $a)
                    <tr class="border-t">
                        <td class="p-3 font-medium">{{ $a->exam_title_snapshot }}</td>
                        <td class="p-3">{{ $a->student_name_snapshot ? $a->student_name_snapshot . ' (' . $a->student_code_snapshot . ')' : '—' }}</td>
                        <td class="p-3 font-mono">{{ $a->code_snapshot }}</td>
                        <td class="p-3">{{ $a->score_percent }}%</td>
                        <td class="p-3">
                            <span class="inline-flex rounded-full px-2 py-1 text-xs
                                {{ $a->status==='OK' ? 'bg-emerald-50 text-emerald-700' : ($a->status==='FLAGGED' ? 'bg-amber-50 text-amber-700' : 'bg-rose-50 text-rose-700') }}">
                                {{ $a->status }}
                            </span>
                        </td>
                        <td class="p-3 flex gap-2 flex-wrap">
                            <a class="rounded-xl border px-3 py-1" href="{{ route('admin.results.show', $a) }}">جزئیات</a>
                            <form method="post" action="{{ route('admin.results.destroy', $a) }}" onsubmit="return confirm('حذف شود؟');">
                                @csrf @method('DELETE')
                                <button class="rounded-xl bg-rose-600 text-white px-3 py-1">حذف</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
                @if($attempts->count()===0)
                    <tr><td class="p-6 text-center text-slate-500" colspan="6">موردی یافت نشد.</td></tr>
                @endif
            </tbody>
        </table>
    </div>

    <div class="mt-4">{{ $attempts->links() }}</div>
</x-admin-layout>
