<x-admin-layout>
    <div class="flex items-center justify-between flex-wrap gap-3">
        <h1 class="text-xl font-bold">جزئیات نتیجه</h1>
        <a class="rounded-2xl border px-4 py-2" href="{{ route('admin.results.index') }}">بازگشت</a>
    </div>

    <div class="mt-4 grid md:grid-cols-2 gap-3">
        <div class="rounded-2xl border bg-white p-4">
            <div class="text-slate-500 text-sm">آزمون</div>
            <div class="font-bold">{{ $attempt->exam_title_snapshot }}</div>
            <div class="mt-2 text-slate-500 text-sm">دانش‌آموز</div>
            <div>{{ $attempt->student_name_snapshot ?? '—' }} {{ $attempt->student_code_snapshot ? '(' . $attempt->student_code_snapshot . ')' : '' }}</div>
            <div class="mt-2 text-slate-500 text-sm">کد</div>
            <div class="font-mono text-lg">{{ $attempt->code_snapshot }}</div>
        </div>
        <div class="rounded-2xl border bg-white p-4">
            <div class="text-slate-500 text-sm">امتیاز</div>
            <div class="text-2xl font-extrabold">{{ $attempt->score_percent }}%</div>
            <div class="mt-2 text-slate-500 text-sm">وضعیت</div>
            <div class="font-mono">{{ $attempt->status }}</div>
            <div class="mt-2 text-slate-500 text-sm">تعویض تب</div>
            <div>{{ $attempt->tab_switch_count }}</div>
        </div>
    </div>

    <div class="mt-4 rounded-2xl border bg-white overflow-auto">
        <table class="min-w-[1000px] w-full text-sm">
            <thead class="bg-slate-50 text-slate-600">
            <tr>
                <th class="p-3 text-right">سوال</th>
                <th class="p-3 text-right">انتخاب</th>
                <th class="p-3 text-right">صحیح</th>
                <th class="p-3 text-right">امتیاز</th>
            </tr>
            </thead>
            <tbody>
            @foreach($attempt->answers as $ans)
                @php($choices = $ans->choices_snapshot)
                <tr class="border-t align-top">
                    <td class="p-3">
                        <div class="font-medium">{{ $ans->question_text_snapshot }}</div>
                        <div class="text-xs text-slate-500 mt-1">
                            A) {{ $choices[0] ?? '' }} | B) {{ $choices[1] ?? '' }} | C) {{ $choices[2] ?? '' }} | D) {{ $choices[3] ?? '' }}
                        </div>
                    </td>
                    <td class="p-3">{{ ['A','B','C','D'][$ans->selected_index] ?? '-' }}</td>
                    <td class="p-3">{{ ['A','B','C','D'][$ans->correct_index_snapshot] ?? '-' }}</td>
                    <td class="p-3">
                        <span class="inline-flex rounded-full px-2 py-1 text-xs {{ $ans->is_correct ? 'bg-emerald-50 text-emerald-700' : 'bg-rose-50 text-rose-700' }}">
                            {{ $ans->score_awarded }}
                        </span>
                    </td>
                </tr>
            @endforeach
            @if($attempt->answers->count()===0)
                <tr><td class="p-6 text-center text-slate-500" colspan="4">پاسخی ثبت نشده.</td></tr>
            @endif
            </tbody>
        </table>
    </div>
</x-admin-layout>
