<x-admin-layout>
    <div class="flex items-center justify-between gap-3 flex-wrap">
        <h1 class="text-xl font-bold">دانش‌آموزان</h1>
        <a href="{{ route('admin.students.create') }}" class="rounded-2xl bg-indigo-600 text-white px-4 py-2">دانش‌آموز جدید</a>
    </div>

    <div class="mt-4">@include('admin._searchbar')</div>

    <div class="mt-4 overflow-auto rounded-2xl border bg-white">
        <table class="min-w-[900px] w-full text-sm">
            <thead class="bg-slate-50 text-slate-600">
                <tr>
                    <th class="p-3 text-right">کد</th>
                    <th class="p-3 text-right">نام</th>
                    <th class="p-3 text-right">کلاس</th>
                    <th class="p-3 text-right">وضعیت</th>
                    <th class="p-3 text-right">عملیات</th>
                </tr>
            </thead>
            <tbody>
                @foreach($students as $s)
                    <tr class="border-t">
                        <td class="p-3 font-mono">{{ $s->student_code }}</td>
                        <td class="p-3 font-medium">{{ $s->full_name }}</td>
                        <td class="p-3">{{ $s->class_name ?? '—' }}</td>
                        <td class="p-3">
                            <span class="inline-flex rounded-full px-2 py-1 text-xs {{ $s->is_active ? 'bg-emerald-50 text-emerald-700' : 'bg-slate-100 text-slate-600' }}">
                                {{ $s->is_active ? 'فعال' : 'غیرفعال' }}
                            </span>
                        </td>
                        <td class="p-3 flex gap-2 flex-wrap">
                            <a class="rounded-xl border px-3 py-1" href="{{ route('admin.students.edit', $s) }}">ویرایش</a>
                            <form method="post" action="{{ route('admin.students.destroy', $s) }}" onsubmit="return confirm('حذف شود؟');">
                                @csrf @method('DELETE')
                                <button class="rounded-xl bg-rose-600 text-white px-3 py-1">حذف</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
                @if($students->count()===0)
                    <tr><td class="p-6 text-center text-slate-500" colspan="5">موردی یافت نشد.</td></tr>
                @endif
            </tbody>
        </table>
    </div>

    <div class="mt-4">{{ $students->links() }}</div>
</x-admin-layout>
