<!doctype html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ $title ?? 'آزمون' }}</title>
    @vite(['resources/css/app.css','resources/js/app.js'])
    <style>
        body { font-family: ui-sans-serif, system-ui, -apple-system, "Vazirmatn", "IRANSans", "Segoe UI", sans-serif; }
    </style>
</head>
<body class="bg-slate-50 text-slate-900">
    <div class="max-w-2xl mx-auto px-4 py-10">
        <div class="flex items-center justify-between mb-6">
            <div class="font-extrabold">سامانه آزمون</div>
            <div class="text-xs text-slate-500">Template v1.0</div>
        </div>

        @if ($errors->any())
            <div class="mb-4 rounded-2xl border border-rose-200 bg-rose-50 px-4 py-3 text-rose-800">
                <ul class="list-disc pr-6">
                    @foreach ($errors->all() as $e)
                        <li>{{ $e }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        {{ $slot }}
    </div>
</body>
</html>
