<x-student-layout>
    <div class="rounded-2xl border bg-white p-6">
        <div class="flex items-center justify-between gap-3 flex-wrap">
            <div>
                <div class="text-slate-500 text-sm">آزمون</div>
                <div class="font-bold text-lg">{{ $exam->title }}</div>
            </div>
            <div class="text-right">
                <div class="text-slate-500 text-sm">زمان باقی‌مانده</div>
                <div id="timer" class="font-mono text-2xl">--:--</div>
            </div>
        </div>

        <form id="examForm" method="post" action="{{ route('student.submit') }}" class="mt-6 grid gap-6">
            @csrf
            <input type="hidden" name="attempt_id" value="{{ $attempt->id }}">
            <input type="hidden" name="tab_switch_count" id="tabSwitchCount" value="0">

            @foreach($questions as $idx => $q)
                <div class="rounded-2xl border p-4">
                    <div class="flex items-start justify-between gap-3">
                        <div class="font-bold">سوال {{ $idx+1 }}</div>
                        <div class="text-xs text-slate-500">امتیاز: {{ $q->score }}</div>
                    </div>

                    <div class="mt-2">{{ $q->question_text }}</div>

                    @if($q->image_path)
                        <img class="mt-3 max-h-64 rounded-2xl border object-contain w-full bg-slate-50" src="{{ asset('storage/'.$q->image_path) }}">
                    @endif

                    <div class="mt-4 grid gap-2">
                        @foreach($q->choices as $cIdx => $choice)
                            <label class="flex items-center gap-3 rounded-2xl border px-3 py-3 hover:bg-slate-50 cursor-pointer">
                                <input type="radio" name="answers[{{ $q->id }}]" value="{{ $cIdx }}" required>
                                <span>{{ ['A','B','C','D'][$cIdx] }})</span>
                                <span>{{ $choice }}</span>
                            </label>
                        @endforeach
                    </div>
                </div>
            @endforeach

            <button class="rounded-2xl bg-indigo-600 text-white px-4 py-3">ارسال پاسخ‌ها</button>
        </form>
    </div>

<script>
(function(){
    const durationMinutes = {{ (int)$exam->duration_minutes }};
    let remaining = durationMinutes * 60;
    const timerEl = document.getElementById('timer');
    const form = document.getElementById('examForm');
    const tabCountEl = document.getElementById('tabSwitchCount');

    function fmt(sec){
        const m = String(Math.floor(sec/60)).padStart(2,'0');
        const s = String(sec%60).padStart(2,'0');
        return m+':'+s;
    }

    function tick(){
        timerEl.textContent = fmt(remaining);
        remaining--;
        if (remaining < 0) {
            alert('زمان آزمون به پایان رسید. پاسخ‌ها ارسال می‌شود.');
            form.submit();
        } else {
            setTimeout(tick, 1000);
        }
    }
    tick();

    // anti-cheat: tab switch counter
    let tabSwitchCount = 0;
    document.addEventListener('visibilitychange', function(){
        if (document.hidden) {
            tabSwitchCount++;
            tabCountEl.value = tabSwitchCount;
        }
    });

    // optional: block copy/paste and right click
    const blockCopyPaste = {{ ($settings && $settings->block_copy_paste) ? 'true' : 'false' }};
    const disableRightClick = {{ ($settings && $settings->disable_right_click) ? 'true' : 'false' }};
    if (blockCopyPaste) {
        ['copy','cut','paste'].forEach(evt => document.addEventListener(evt, (e)=>e.preventDefault()));
    }
    if (disableRightClick) {
        document.addEventListener('contextmenu', (e)=>e.preventDefault());
    }
})();
</script>
</x-student-layout>
