<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\ExamController;
use App\Http\Controllers\Admin\QuestionController;
use App\Http\Controllers\Admin\StudentController;
use App\Http\Controllers\Admin\CodeController;
use App\Http\Controllers\Admin\ResultController;
use App\Http\Controllers\Admin\SettingsController;
use App\Http\Controllers\Admin\AccountController;
use App\Http\Controllers\Student\TakeExamController;

Route::get('/', fn() => redirect()->route('student.enterCode'));

Route::get('/student', [TakeExamController::class, 'enterCode'])->name('student.enterCode');
Route::post('/student/enter-code', [TakeExamController::class, 'postEnterCode'])->name('student.postEnterCode');
Route::post('/student/start', [TakeExamController::class, 'start'])->name('student.start');
Route::post('/student/submit', [TakeExamController::class, 'submit'])->name('student.submit');

Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/', fn() => redirect()->route('admin.exams.index'))->name('home');

    Route::resource('exams', ExamController::class)->except(['show']);

    Route::get('exams/{exam}/questions', [QuestionController::class, 'index'])->name('questions.index');
    Route::post('exams/{exam}/questions', [QuestionController::class, 'store'])->name('questions.store');
    Route::put('questions/{question}', [QuestionController::class, 'update'])->name('questions.update');
    Route::post('questions/{question}/toggle', [QuestionController::class, 'toggle'])->name('questions.toggle');
    Route::post('questions/{question}/image', [QuestionController::class, 'uploadImage'])->name('questions.image');
    Route::delete('questions/{question}', [QuestionController::class, 'destroy'])->name('questions.destroy');

    Route::resource('students', StudentController::class)->except(['show']);

    Route::get('exams/{exam}/codes', [CodeController::class, 'index'])->name('codes.index');
    Route::post('exams/{exam}/codes', [CodeController::class, 'generate'])->name('codes.generate');
    Route::delete('codes/{code}', [CodeController::class, 'destroy'])->name('codes.destroy');

    Route::get('results', [ResultController::class, 'index'])->name('results.index');
    Route::get('results/{attempt}', [ResultController::class, 'show'])->name('results.show');
    Route::delete('results/{attempt}', [ResultController::class, 'destroy'])->name('results.destroy');

    Route::get('settings/anticheat', [SettingsController::class, 'anticheat'])->name('settings.anticheat');
    Route::post('settings/anticheat', [SettingsController::class, 'saveAnticheat'])->name('settings.anticheat.save');

    Route::get('account/security', [AccountController::class, 'security'])->name('account.security');
    Route::post('account/change-password', [AccountController::class, 'changePassword'])->name('account.changePassword');
    Route::get('account/2fa', [AccountController::class, 'twofa'])->name('account.twofa');
});
